/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.dispatch;

import com.digiwin.athena.framework.dispatch.LocalDispatcherInterceptor;
import com.digiwin.athena.framework.dispatch.RestLocalProperties;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableConfigurationProperties(value={RestLocalProperties.class})
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnProperty(prefix="athena.dispatch", name={"enable"}, havingValue="true")
public class LocalDispatchAutoConfiguration {
    @Bean
    public ApplicationListener<ContextRefreshedEvent> restTemplateInterceptorInjector(WebApplicationContext context, @Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping mapping, DispatcherServlet dispatcherServlet, RestLocalProperties properties) {
        return event -> {
            Map restTemplates = context.getBeansOfType(RestTemplate.class);
            restTemplates.values().forEach(restTemplate -> {
                ArrayList<LocalDispatcherInterceptor> interceptors = new ArrayList<LocalDispatcherInterceptor>(restTemplate.getInterceptors());
                interceptors.add(new LocalDispatcherInterceptor(context, mapping, dispatcherServlet, properties));
                restTemplate.setInterceptors(interceptors);
            });
        };
    }
}

