package com.digiwin.athena.framework.dispatch;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Configuration
@EnableConfigurationProperties(RestLocalProperties.class)
@ConditionalOnClass(RestTemplate.class)
@ConditionalOnProperty(prefix = "athena.dispatch", name = "enable", havingValue = "true")
public class LocalDispatchAutoConfiguration {

    @Bean
    public ApplicationListener<ContextRefreshedEvent> restTemplateInterceptorInjector(WebApplicationContext context, @Qualifier("requestMappingHandlerMapping") RequestMappingHandlerMapping mapping, DispatcherServlet dispatcherServlet, RestLocalProperties properties) {
        return event -> {
            Map<String, RestTemplate> restTemplates = context.getBeansOfType(RestTemplate.class);
            restTemplates.values().forEach(restTemplate -> {
                List<ClientHttpRequestInterceptor> interceptors = new ArrayList<>(restTemplate.getInterceptors());
                interceptors.add(new LocalDispatcherInterceptor(context, mapping, dispatcherServlet, properties));
                restTemplate.setInterceptors(interceptors);
            });
        };
    }

    @Bean
    public LocalDispatcherConfigUpdater localDispatcherConfigUpdater(RestLocalProperties configurer) {
        return new LocalDispatcherConfigUpdater(configurer);
    }
}