package com.digiwin.athena.framework.mongodb;

import com.digiwin.athena.framework.mongodb.configurate.DynamicMongoAopConfiguration;
import com.digiwin.athena.framework.mongodb.configurate.DynamicMongoClientConfiguration;
import com.digiwin.athena.framework.mongodb.configurate.DynamicMongoClientFactoryConfiguration;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * @author changgg
 */
@Configuration(proxyBeanMethods = false)
@EnableConfigurationProperties({DynamicMongodbProperties.class})
@ConditionalOnProperty(prefix = DynamicMongodbProperties.PREFIX, name = "enabled", havingValue = "true", matchIfMissing = true)
@Import({DynamicMongoAopConfiguration.class, DynamicMongoClientConfiguration.class, DynamicMongoClientFactoryConfiguration.class})
@AutoConfigureAfter(MongoAutoConfiguration.class)
public class DynamicMongoAutoConfiguration {

}
