/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.factory;

import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import com.digiwin.athena.framework.mongodb.context.DynamicMongoDatabaseContextHolder;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientFactory;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractDynamicMongoDatabaseFactory
extends SimpleMongoClientDatabaseFactory {
    private final Logger logger = LoggerFactory.getLogger(AbstractDynamicMongoDatabaseFactory.class);
    protected final DynamicMongoClientFactory dynamicMongoClientFactory;

    protected AbstractDynamicMongoDatabaseFactory(MongoClient mongoClient, String databaseName, DynamicMongoClientFactory dynamicMongoClientFactory) {
        super(mongoClient, databaseName);
        this.dynamicMongoClientFactory = dynamicMongoClientFactory;
    }

    protected MongoClient getMongoClient() {
        DynamicMongoContext context = this.getContext();
        MongoClient client = context != null && StringUtils.hasText((String)context.getInstanceId()) ? this.dynamicMongoClientFactory.getDynamicMongoClient(context.getInstanceId()) : (MongoClient)super.getMongoClient();
        Assert.notNull((Object)client, (String)("no dynamic mongo database instance found for " + context));
        return client;
    }

    public MongoDatabase getMongoDatabase() throws DataAccessException {
        DynamicMongoContext context = this.getContext();
        return context != null && StringUtils.hasText((String)context.getDatabase()) ? this.getMongoDatabase(context.getDatabase()) : super.getMongoDatabase();
    }

    protected DynamicMongoContext getContext() {
        DynamicMongoContext context = DynamicMongoDatabaseContextHolder.peek();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("excepted dynamic mongodb instance is [{}],use default mongo client:[{}]", (Object)context, (Object)(context != null && !StringUtils.hasText((String)context.getInstanceId()) ? 1 : 0));
        }
        return context;
    }
}

