/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.configurate;

import com.digiwin.athena.framework.mongodb.annotation.MDS;
import com.digiwin.athena.framework.mongodb.aop.DynamicMongoAnnotationAdvisor;
import com.digiwin.athena.framework.mongodb.aop.DynamicMongoAnnotationInterceptor;
import com.digiwin.athena.framework.mongodb.parser.AbstractChainValueParser;
import com.digiwin.athena.framework.mongodb.parser.DynamicContextValueParser;
import com.digiwin.athena.framework.mongodb.parser.HeaderValueParser;
import com.digiwin.athena.framework.mongodb.parser.SessionValueParser;
import com.digiwin.athena.framework.mongodb.parser.SpElValueParser;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongoInterceptorProperties;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoClassResolver;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoContextResolver;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.Ordered;
import org.springframework.expression.BeanResolver;

@Configuration
public class DynamicMongoInterceptorConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DynamicMongoInterceptorConfiguration.class);

    @Role(value=2)
    @Bean
    public Advisor dynamicMongoClientAnnotationAdvisor(DynamicMongodbProperties properties, DynamicMongoContextResolver resolver, DynamicContextValueParser valueParser) {
        log.info("register dynamic mongo client aop");
        DynamicMongoInterceptorProperties aopProperties = properties.getInterceptor();
        DynamicMongoAnnotationInterceptor interceptor = new DynamicMongoAnnotationInterceptor(resolver, valueParser);
        DynamicMongoAnnotationAdvisor advisor = new DynamicMongoAnnotationAdvisor(interceptor, MDS.class);
        advisor.setOrder(aopProperties.getOrder());
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicMongoContextResolver dynamicMongoClassResolver(DynamicMongodbProperties properties) {
        log.info("register dynamic mongo context resolver");
        return new DynamicMongoClassResolver(properties.getInterceptor().getAllowedPublicOnly());
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicContextValueParser dynamicContextParserOnServlet(BeanFactory beanFactory, DynamicMongodbProperties properties, ObjectProvider<DynamicContextValueParser> customParsers) {
        log.info("register dynamic mongo context value parser on servlet");
        List<String> parserList = properties.getInterceptor().getParsers();
        ArrayList<OrderedParser> allParsers = new ArrayList<OrderedParser>();
        if (parserList.contains("spel")) {
            SpElValueParser spEl = new SpElValueParser();
            spEl.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
            allParsers.add(new OrderedParser(spEl, 10));
        }
        if (parserList.contains("header")) {
            allParsers.add(new OrderedParser(new HeaderValueParser(), 20));
        }
        if (parserList.contains("session")) {
            allParsers.add(new OrderedParser(new SessionValueParser(), 30));
        }
        customParsers.orderedStream().forEach(parser -> {
            int order = parser instanceof Ordered ? ((Ordered)parser).getOrder() : 50;
            allParsers.add(new OrderedParser((AbstractChainValueParser)parser, order));
        });
        allParsers.sort(Comparator.comparingInt(OrderedParser::getOrder));
        AbstractChainValueParser head = null;
        AbstractChainValueParser current = null;
        for (OrderedParser op : allParsers) {
            if (head == null) {
                head = op.getParser();
            }
            if (current != null) {
                current.setNextParser(op.getParser());
            }
            current = op.getParser();
        }
        return head != null ? head : new SpElValueParser();
    }

    static class OrderedParser {
        private final AbstractChainValueParser parser;
        private final int order;

        public OrderedParser(AbstractChainValueParser parser, int order) {
            this.parser = parser;
            this.order = order;
        }

        public AbstractChainValueParser getParser() {
            return this.parser;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

