package com.digiwin.athena.framework.mongodb.configurate;

import com.digiwin.athena.framework.mongodb.annotation.MDS;
import com.digiwin.athena.framework.mongodb.aop.DynamicMongoAnnotationAdvisor;
import com.digiwin.athena.framework.mongodb.aop.DynamicMongoAnnotationInterceptor;
import com.digiwin.athena.framework.mongodb.parser.*;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongoInterceptorProperties;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoClassResolver;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoContextResolver;
import lombok.extern.slf4j.Slf4j;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.Ordered;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

@Slf4j
@Configuration
public class DynamicMongoInterceptorConfiguration {

    @Role(BeanDefinition.ROLE_INFRASTRUCTURE)
    @Bean
    public Advisor dynamicMongoClientAnnotationAdvisor(DynamicMongodbProperties properties, DynamicMongoContextResolver resolver, DynamicContextValueParser valueParser) {
        log.info("register dynamic mongo client aop");
        DynamicMongoInterceptorProperties aopProperties = properties.getInterceptor();
        DynamicMongoAnnotationInterceptor interceptor = new DynamicMongoAnnotationInterceptor(resolver, valueParser);
        DynamicMongoAnnotationAdvisor advisor = new DynamicMongoAnnotationAdvisor(interceptor, MDS.class);
        advisor.setOrder(aopProperties.getOrder());
        return advisor;
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicMongoContextResolver dynamicMongoClassResolver(DynamicMongodbProperties properties) {
        log.info("register dynamic mongo context resolver");
        return new DynamicMongoClassResolver(properties.getInterceptor().getAllowedPublicOnly());
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicContextValueParser dynamicContextParserOnServlet(BeanFactory beanFactory, DynamicMongodbProperties properties, ObjectProvider<DynamicContextValueParser> customParsers) {

        log.info("register dynamic mongo context value parser on servlet");

        List<String> parserList = properties.getInterceptor().getParsers();
        List<OrderedParser> allParsers = new ArrayList<>();

//        if (parserList.contains("spel")) {
            SpElValueParser spEl = new SpElValueParser();
            spEl.setBeanResolver(new BeanFactoryResolver(beanFactory));
            allParsers.add(new OrderedParser(spEl, 10));
//        }
        // 系统 Parser
        if (parserList.contains("header")) {
            allParsers.add(new OrderedParser(new HeaderValueParser(), 20));
        }
        if (parserList.contains("session")) {
            allParsers.add(new OrderedParser(new SessionValueParser(), 30));
        }

        // 自定义 Parser
        customParsers.orderedStream().forEach(parser -> {
            int order = (parser instanceof Ordered) ? ((Ordered) parser).getOrder() : 50;
            allParsers.add(new OrderedParser((AbstractChainValueParser) parser, order));
        });

        // 按顺序排序
        allParsers.sort(Comparator.comparingInt(OrderedParser::getOrder));

        // 串成链
        AbstractChainValueParser head = null;
        AbstractChainValueParser current = null;
        for (OrderedParser op : allParsers) {
            if (head == null) {
                head = op.getParser();
            }
            if (current != null) {
                current.setNextParser(op.getParser());
            }
            current = op.getParser();
        }
        return head != null ? head : new SpElValueParser();
    }

    static class OrderedParser {
        private final AbstractChainValueParser parser;
        private final int order;

        public OrderedParser(AbstractChainValueParser parser, int order) {
            this.parser = parser;
            this.order = order;
        }

        public AbstractChainValueParser getParser() {
            return parser;
        }

        public int getOrder() {
            return order;
        }
    }
}
