/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.resolver;

import com.digiwin.athena.framework.mongodb.annotation.MDS;
import com.digiwin.athena.framework.mongodb.context.DefaultDynamicMongoContext;
import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoContextResolver;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodClassKey;
import org.springframework.core.annotation.AnnotationUtils;

public class DynamicMongoClassResolver
implements DynamicMongoContextResolver {
    private static final Logger log = LoggerFactory.getLogger(DynamicMongoClassResolver.class);
    private final Map<Object, DynamicMongoContext> contextCache = new HashMap<Object, DynamicMongoContext>();
    private final boolean allowedPublicOnly;
    private final Object lock = new Object();

    public DynamicMongoClassResolver(boolean allowedPublicOnly) {
        this.allowedPublicOnly = allowedPublicOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DynamicMongoContext resolve(Method method, Object targetObject) {
        boolean isDebugEnabled = log.isDebugEnabled();
        if (method.getDeclaringClass() == Object.class) {
            if (isDebugEnabled) {
                log.debug("the method belongs to Object class,skip it");
            }
            return new DefaultDynamicMongoContext();
        }
        MethodClassKey cacheKey = new MethodClassKey(method, targetObject.getClass());
        DynamicMongoContext context = this.contextCache.get(cacheKey);
        if (context == null) {
            if (isDebugEnabled) {
                log.debug("not found in cache try second lock");
            }
            Object object = this.lock;
            synchronized (object) {
                context = this.contextCache.get(cacheKey);
                if (context == null) {
                    context = this.resolveContext(method);
                    if (context == null) {
                        if (isDebugEnabled) {
                            log.debug("cant not resolve the context,just create default");
                        }
                        context = new DefaultDynamicMongoContext();
                    }
                    if (isDebugEnabled) {
                        log.debug("cache context:{}", (Object)context);
                    }
                    this.contextCache.put(cacheKey, context);
                }
            }
        }
        return context;
    }

    protected DynamicMongoContext resolveContext(Method method) {
        if (this.allowedPublicOnly && !Modifier.isPublic(method.getModifiers())) {
            return null;
        }
        MDS annotation = (MDS)AnnotationUtils.getAnnotation((Method)method, MDS.class);
        if (annotation == null) {
            annotation = (MDS)AnnotationUtils.getAnnotation(method.getDeclaringClass(), MDS.class);
        }
        if (annotation == null) {
            return null;
        }
        return new DefaultDynamicMongoContext(annotation.instanceId(), annotation.databaseName());
    }
}

