/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.parser;

import com.digiwin.athena.framework.mongodb.parser.AbstractChainValueParser;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SessionValueParser
extends AbstractChainValueParser {
    public static final String SESSION_PREFIX = "#session";

    @Override
    public boolean match(String value) {
        return value.startsWith(SESSION_PREFIX);
    }

    @Override
    public String doParse(MethodInvocation invocation, String value) {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        return request.getSession().getAttribute(value.substring(SESSION_PREFIX.length())).toString();
    }
}

