package com.digiwin.athena.framework.mongodb.aop;

import com.digiwin.athena.framework.mongodb.factory.DynamicMongoDatabaseFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;

public class MongoTemplateBeanPostProcessor implements BeanPostProcessor {

    private final DynamicMongoDatabaseFactory dynamicMongoDatabaseFactory;
    private final MappingMongoConverter converter;

    public MongoTemplateBeanPostProcessor(DynamicMongoDatabaseFactory factory, MappingMongoConverter converter) {
        this.dynamicMongoDatabaseFactory = factory;
        this.converter = converter;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof MongoTemplate) {
            return new MongoTemplate(dynamicMongoDatabaseFactory, converter);
        }
        return bean;
    }
}

