package com.digiwin.athena.framework.mongodb.properties;

import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Map;

@ConfigurationProperties(prefix = DynamicMongodbProperties.PREFIX)
public class DynamicMongodbProperties {

    public static final String PREFIX = "spring.data.mongodb.dynamic";

    private String uri;

    private String database;

    private Map<String, MongoProperties> config;

    @NestedConfigurationProperty
    private DynamicMongoInterceptorProperties interceptor = new DynamicMongoInterceptorProperties();

    public Map<String, MongoProperties> getConfig() {
        return config;
    }

    public void setConfig(Map<String, MongoProperties> config) {
        this.config = config;
    }

    public DynamicMongoInterceptorProperties getInterceptor() {
        return interceptor;
    }

    public void setInterceptor(DynamicMongoInterceptorProperties interceptor) {
        this.interceptor = interceptor;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getDatabase() {
        return database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }
}