/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.context;

import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import com.digiwin.athena.framework.mongodb.parser.DynamicContextValueParser;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultDynamicMongoContext
implements DynamicMongoContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultDynamicMongoContext.class);
    private String instanceId;
    private String database;

    public DefaultDynamicMongoContext() {
        this.instanceId = "";
        this.database = "";
    }

    public DefaultDynamicMongoContext(String instanceId, String database) {
        this.instanceId = StringUtils.hasText((String)instanceId) ? instanceId : "";
        this.database = StringUtils.hasText((String)database) ? database : "";
    }

    @Override
    public void parseValue(MethodInvocation invocation, DynamicContextValueParser valueParser) {
        boolean isDebugEnabled = log.isDebugEnabled();
        if (isDebugEnabled) {
            log.debug("before parse context:{}", (Object)this);
        }
        if (valueParser != null) {
            if (StringUtils.hasText((String)this.instanceId)) {
                this.instanceId = valueParser.parse(invocation, this.instanceId);
            }
            if (StringUtils.hasText((String)this.database)) {
                this.database = valueParser.parse(invocation, this.database);
            }
        }
        if (isDebugEnabled) {
            log.debug("after parse context:{}", (Object)this);
        }
    }

    @Override
    public String getInstanceId() {
        return this.instanceId;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public String toString() {
        return "DefaultDynamicMongoContext{instanceId='" + this.instanceId + '\'' + ", database='" + this.database + '\'' + '}';
    }
}

