/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.configurate;

import com.digiwin.athena.framework.mongodb.factory.SimpleDynamicMongoClientFactory;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientBuilder;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class DynamicMongoClientFactoryConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DynamicMongoClientFactoryConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public DynamicMongoClientFactory dynamicMongoClientHolder(DynamicMongodbProperties properties, DynamicMongoClientBuilder mongoClientBuilder) {
        this.logger.info("register simple dynamic mongo client factory");
        return new SimpleDynamicMongoClientFactory(properties, mongoClientBuilder);
    }
}

