/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.factory;

import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientBuilder;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientFactory;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;

public class SimpleDynamicMongoClientFactory
implements DynamicMongoClientFactory,
InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(SimpleDynamicMongoClientFactory.class);
    private final DynamicMongodbProperties properties;
    private final DynamicMongoClientBuilder mongoClientBuilder;
    private Map<String, MongoClient> dynamicMongoClients;

    public SimpleDynamicMongoClientFactory(DynamicMongodbProperties properties, DynamicMongoClientBuilder mongoClientBuilder) {
        this.properties = properties;
        this.mongoClientBuilder = mongoClientBuilder;
    }

    @Override
    public MongoClient getDynamicMongoClient(String key) {
        return this.dynamicMongoClients != null ? this.dynamicMongoClients.get(key) : null;
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, MongoProperties> config = this.properties.getConfig();
        if (config == null || config.isEmpty()) {
            throw new IllegalStateException("\u8bf7\u81f3\u5c11\u5728 spring.data.mongodb.dynamic.config \u4e0b\u5b9a\u4e49\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        this.dynamicMongoClients = new HashMap<String, MongoClient>(config.size());
        for (Map.Entry<String, MongoProperties> entry : config.entrySet()) {
            this.logger.info("init dynamic mongo database for {}", (Object)entry.getKey());
            ConnectionString connectionString = new ConnectionString(entry.getValue().determineUri());
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            this.dynamicMongoClients.put(entry.getKey(), MongoClients.create((MongoClientSettings)settings));
        }
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, MongoClient> entry : this.dynamicMongoClients.entrySet()) {
            this.logger.info("closing dynamic mongo client for name:{} ...", (Object)entry.getKey());
            try {
                MongoClient client = entry.getValue();
                if (client == null) continue;
                client.close();
            }
            catch (Exception e) {
                this.logger.error("close dynamic mongo client failed for name:{},msg:{}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
    }
}

