/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.factory;

import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientBuilder;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientFactory;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.util.StringUtils;

public class SimpleDynamicMongoClientFactory
implements DynamicMongoClientFactory,
InitializingBean,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(SimpleDynamicMongoClientFactory.class);
    private final DynamicMongodbProperties properties;
    private final DynamicMongoClientBuilder mongoClientBuilder;
    private Map<String, MongoClient> dynamicMongoClients;

    public SimpleDynamicMongoClientFactory(DynamicMongodbProperties properties, DynamicMongoClientBuilder mongoClientBuilder) {
        this.properties = properties;
        this.mongoClientBuilder = mongoClientBuilder;
    }

    @Override
    public MongoClient getDynamicMongoClient(String key) {
        return this.dynamicMongoClients != null ? this.dynamicMongoClients.get(key) : null;
    }

    public void afterPropertiesSet() throws Exception {
        Map<String, MongoProperties> config = this.properties.getConfig();
        if (config == null || config.isEmpty()) {
            throw new IllegalStateException("\u8bf7\u81f3\u5c11\u5728 spring.data.mongodb.dynamic.config \u4e0b\u5b9a\u4e49\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        this.dynamicMongoClients = new HashMap<String, MongoClient>(config.size());
        ConcurrentHashMap<String, MongoClient> uriClientCache = new ConcurrentHashMap<String, MongoClient>();
        if (!StringUtils.isEmpty((Object)this.properties.getUri())) {
            String mongoUrl = this.properties.getUri();
            ConnectionString connectionString = new ConnectionString(mongoUrl);
            MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
            MongoClient mongoClient = MongoClients.create((MongoClientSettings)settings);
            for (String key : config.keySet()) {
                this.logger.info("init dynamic mongo database for {} -> {}", (Object)key, (Object)mongoUrl);
                this.dynamicMongoClients.put(key, mongoClient);
            }
        } else {
            for (Map.Entry<String, MongoProperties> entry : config.entrySet()) {
                String mongoUrl = entry.getValue().determineUri();
                MongoClient mongoClient = uriClientCache.computeIfAbsent(mongoUrl, url -> {
                    ConnectionString connectionString = new ConnectionString(url);
                    MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
                    this.logger.info("create new MongoClient for URI: {}", url);
                    return MongoClients.create((MongoClientSettings)settings);
                });
                this.logger.info("init dynamic mongo database for {} -> {}", (Object)entry.getKey(), (Object)mongoUrl);
                this.dynamicMongoClients.put(entry.getKey(), mongoClient);
            }
        }
    }

    public void destroy() throws Exception {
        for (Map.Entry<String, MongoClient> entry : this.dynamicMongoClients.entrySet()) {
            this.logger.info("closing dynamic mongo client for name:{} ...", (Object)entry.getKey());
            try {
                MongoClient client = entry.getValue();
                if (client == null) continue;
                client.close();
            }
            catch (Exception e) {
                this.logger.error("close dynamic mongo client failed for name:{},msg:{}", (Object)entry.getKey(), (Object)e.getMessage());
            }
        }
    }
}

