/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.configurate;

import com.digiwin.athena.framework.mongodb.factory.DynamicMongoDatabaseFactory;
import com.digiwin.athena.framework.mongodb.processor.MongoTemplateBeanPostProcessor;
import com.digiwin.athena.framework.mongodb.properties.DynamicMongodbProperties;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientBuilder;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientFactory;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientPropertiesCustomizer;
import com.digiwin.athena.framework.mongodb.support.DynamicMongoClientSettingsCustomizer;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.mongo.MongoClientFactory;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.autoconfigure.mongo.MongoPropertiesClientSettingsBuilderCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
public class DynamicMongoClientConfiguration {
    private final Logger logger = LoggerFactory.getLogger(DynamicMongoClientConfiguration.class);

    @Bean
    @Primary
    public MongoClient primaryMongoClient(DynamicMongodbProperties properties) {
        Map<String, MongoProperties> config = properties.getConfig();
        if (config == null || config.isEmpty()) {
            throw new IllegalStateException("\u8bf7\u81f3\u5c11\u5728 spring.data.mongodb.dynamic.config \u4e0b\u5b9a\u4e49\u4e00\u4e2a\u6570\u636e\u6e90");
        }
        Map.Entry<String, MongoProperties> firstEntry = config.entrySet().iterator().next();
        MongoProperties firstProps = firstEntry.getValue();
        String mongoUrl = "";
        mongoUrl = !StringUtils.isEmpty((Object)properties.getUri()) ? properties.getUri() : firstProps.determineUri();
        ConnectionString connectionString = new ConnectionString(mongoUrl);
        MongoClientSettings settings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        return MongoClients.create((MongoClientSettings)settings);
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoTemplateBeanPostProcessor mongoTemplateBeanPostProcessor(MongoDatabaseFactory mongoDatabaseFactory, MappingMongoConverter mappingMongoConverter) {
        return new MongoTemplateBeanPostProcessor(mongoDatabaseFactory, mappingMongoConverter);
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoDatabaseFactory mongoClientFactory(MongoClient mongoClient, MongoProperties properties, DynamicMongoClientFactory dynamicMongoClientFactory) {
        this.logger.info("register dynamic mongo database factory");
        return new DynamicMongoDatabaseFactory(mongoClient, properties.getMongoClientDatabase(), dynamicMongoClientFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicMongoClientBuilder dynamicMongoClientBuilder(MongoProperties primaryProperties, ObjectProvider<DynamicMongoClientSettingsCustomizer> settingsCustomizers, ObjectProvider<DynamicMongoClientPropertiesCustomizer> propertiesCustomizers) {
        this.logger.info("register dynamic mongo client builder");
        return (instanceId, properties) -> {
            propertiesCustomizers.orderedStream().forEach(customizers -> customizers.customize(primaryProperties, instanceId, properties));
            return (MongoClient)new MongoClientFactory(Collections.singletonList(clientSettingsBuilder -> settingsCustomizers.orderedStream().forEach(customizers -> customizers.customize(instanceId, clientSettingsBuilder, properties)))).createMongoClient(MongoClientSettings.builder().build());
        };
    }

    @Bean(value={"dynamicMongoClientSettingsCustomizer"})
    @ConditionalOnMissingBean(name={"dynamicMongoClientSettingsCustomizer"})
    public DynamicMongoClientSettingsCustomizer dynamicMongoClientSettingsCustomizer(Environment environment) {
        this.logger.info("register dynamic mongo client setting customizer");
        return (instanceId, dynamic, properties) -> new MongoPropertiesClientSettingsBuilderCustomizer(properties, environment).customize(dynamic);
    }
}

