/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.parser;

import com.digiwin.athena.framework.mongodb.parser.AbstractChainValueParser;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.context.expression.MethodBasedEvaluationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpElValueParser
extends AbstractChainValueParser {
    private static final ParameterNameDiscoverer NAME_DISCOVERER = new DefaultParameterNameDiscoverer();
    private static final ExpressionParser PARSER = new SpelExpressionParser();
    private ParserContext parserContext = new TemplateParserContext();
    private BeanResolver beanResolver;
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();

    @Override
    public boolean match(String value) {
        return true;
    }

    @Override
    public String doParse(MethodInvocation invocation, String key) {
        Method method = invocation.getMethod();
        Object[] arguments = invocation.getArguments();
        ExpressionRootObject rootObject = new ExpressionRootObject(method, arguments, invocation.getThis());
        MethodBasedEvaluationContext context = new MethodBasedEvaluationContext((Object)rootObject, method, arguments, NAME_DISCOVERER);
        context.setBeanResolver(this.beanResolver);
        Expression expression = this.getExpression(key);
        String value = (String)expression.getValue((EvaluationContext)context, String.class);
        return value;
    }

    private Expression getExpression(String key) {
        return this.expressionCache.computeIfAbsent(key + ":" + (this.parserContext != null), k -> this.parserContext != null ? PARSER.parseExpression(key, this.parserContext) : PARSER.parseExpression(key));
    }

    public void setParserContext(ParserContext parserContext) {
        this.parserContext = parserContext;
    }

    public void setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
    }

    public static class ExpressionRootObject {
        private final Method method;
        private final Object[] args;
        private final Object target;

        public ExpressionRootObject(Method method, Object[] args, Object target) {
            this.method = method;
            this.args = args;
            this.target = target;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

