package com.digiwin.athena.framework.mongodb.processor;

import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;

public class MongoTemplateBeanPostProcessor implements BeanPostProcessor {

    private final MongoDatabaseFactory mongoDatabaseFactory;
    private final MappingMongoConverter converter;

    public MongoTemplateBeanPostProcessor(MongoDatabaseFactory factory, MappingMongoConverter converter) {
        this.mongoDatabaseFactory = factory;
        this.converter = converter;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof MongoTemplate) {
            return new MongoTemplate(mongoDatabaseFactory, converter);
        }
        return bean;
    }
}

