package com.digiwin.athena.framework.mongodb.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.core.annotation.AliasFor;

@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface MDS {
    /**
     * 数据源名称
     *
     * @return 名称
     */
    @AliasFor(value = "instanceId")
    String value() default "";

    /**
     * 实例ID
     *
     * @return 实例ID
     */
    @AliasFor(value = "value")
    String instanceId() default "";

    /**
     * 库名
     *
     * @return 库名
     */
    String databaseName() default "";
}
