package com.digiwin.athena.framework.mongodb.aop;

import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import com.digiwin.athena.framework.mongodb.context.DynamicMongoDatabaseContextHolder;
import com.digiwin.athena.framework.mongodb.parser.DynamicContextValueParser;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoContextResolver;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class DynamicMongoAnnotationInterceptor implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMongoAnnotationInterceptor.class);
    private final DynamicMongoContextResolver resolver;
    private final DynamicContextValueParser valueParser;

    public DynamicMongoAnnotationInterceptor(DynamicMongoContextResolver resolver, DynamicContextValueParser valueParser) {
        this.resolver = resolver;
        this.valueParser = valueParser;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        final DynamicMongoContext context = DynamicMongoDatabaseContextHolder.push(determineDatabaseInstance(invocation));
        if (logger.isDebugEnabled()) {
            logger.debug("excepted dynamic mongodb instance is [{}]", context);
        }
        try {
            return invocation.proceed();
        } finally {
            DynamicMongoDatabaseContextHolder.poll();
        }
    }

    private DynamicMongoContext determineDatabaseInstance(MethodInvocation invocation) {
        DynamicMongoContext context = resolver.resolve(invocation.getMethod(), invocation.getThis());
        if (context != null) {
            context.parseValue(invocation, valueParser);
        }
        return context;
    }
}
