package com.digiwin.athena.framework.mongodb.properties;

import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

import java.util.Map;

@ConfigurationProperties(prefix = DynamicMongodbProperties.PREFIX)
public class DynamicMongodbProperties {

    public static final String PREFIX = "spring.data.mongodb.dynamic";

    private String uri;

    private Map<String, MongoProperties> pool;

    @NestedConfigurationProperty
    private DynamicMongoInterceptorProperties interceptor = new DynamicMongoInterceptorProperties();


    public Map<String, MongoProperties> getPool() {
        return pool;
    }

    public void setPool(Map<String, MongoProperties> pool) {
        this.pool = pool;
    }

    public DynamicMongoInterceptorProperties getInterceptor() {
        return interceptor;
    }

    public void setInterceptor(DynamicMongoInterceptorProperties interceptor) {
        this.interceptor = interceptor;
    }

    public String getUri() {
        return uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}