/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.aop;

import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import com.digiwin.athena.framework.mongodb.context.DynamicMongoDatabaseContextHolder;
import com.digiwin.athena.framework.mongodb.parser.DynamicContextValueParser;
import com.digiwin.athena.framework.mongodb.resolver.DynamicMongoContextResolver;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMongoAnnotationInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMongoAnnotationInterceptor.class);
    private final DynamicMongoContextResolver resolver;
    private final DynamicContextValueParser valueParser;

    public DynamicMongoAnnotationInterceptor(DynamicMongoContextResolver resolver, DynamicContextValueParser valueParser) {
        this.resolver = resolver;
        this.valueParser = valueParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        DynamicMongoContext context = DynamicMongoDatabaseContextHolder.push(this.determineDatabaseInstance(invocation));
        if (logger.isDebugEnabled()) {
            logger.debug("excepted dynamic mongodb instance is [{}]", (Object)context);
        }
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DynamicMongoDatabaseContextHolder.poll();
        }
    }

    private DynamicMongoContext determineDatabaseInstance(MethodInvocation invocation) {
        DynamicMongoContext context = this.resolver.resolve(invocation.getMethod(), invocation.getThis());
        if (context != null) {
            context.parseValue(invocation, this.valueParser);
        }
        return context;
    }
}

