/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.mongodb.context;

import com.digiwin.athena.framework.mongodb.context.DefaultDynamicMongoContext;
import com.digiwin.athena.framework.mongodb.context.DynamicMongoContext;
import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.core.NamedThreadLocal;

public final class DynamicMongoDatabaseContextHolder {
    private static final ThreadLocal<Deque<DynamicMongoContext>> LOOKUP_KEY_HOLDER = new NamedThreadLocal<Deque<DynamicMongoContext>>("dynamic-mongo-database"){

        protected Deque<DynamicMongoContext> initialValue() {
            return new ArrayDeque<DynamicMongoContext>();
        }
    };

    private DynamicMongoDatabaseContextHolder() {
    }

    public static DynamicMongoContext peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static DynamicMongoContext push(DynamicMongoContext context) {
        if (context == null) {
            context = new DefaultDynamicMongoContext();
        }
        LOOKUP_KEY_HOLDER.get().push(context);
        return context;
    }

    public static void poll() {
        Deque<DynamicMongoContext> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

