package com.digiwin.athena.framework.http.config;

import com.digiwin.athena.framework.core.util.DwNacosUtil;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;

public class DwDomainPostPropertyHandler implements JaCenterPropertyHandler {
    @Override
    public void addAndCover() {
        try {
            if (DwNacosUtil.isExistsJaNacosConfigService()) {
                JaNacosConfigService.loadYaml("biz-http.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());

            }
        } catch (Throwable e) {
            JaLog.error("dw-domain config load error", e);
        }
    }

    /**
     * 先于应用被读取。 应用自己配置，可以覆盖（以应用为准）
     */
    @Override
    public int order() {
        return -20;
    }
}
