/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.jsoni18n;

import com.digiwin.athena.framework.jsoni18n.utils.I18nUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nMapSerializer
extends JsonSerializer<Map<String, Object>> {
    public void serialize(Map<String, Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        String locale = LocaleContextHolder.getLocale().toString();
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof String) {
                String localizedValue = I18nUtils.extractLocalizedValue((String)fieldValue, locale);
                if (StringUtils.isBlank((CharSequence)localizedValue)) {
                    localizedValue = (String)fieldValue;
                }
                gen.writeStringField(entry.getKey(), localizedValue);
                continue;
            }
            if (fieldValue instanceof Map) {
                gen.writeFieldName(entry.getKey());
                this.serialize((Map)fieldValue, gen, serializers);
                continue;
            }
            gen.writeObjectField(entry.getKey(), fieldValue);
        }
        gen.writeEndObject();
    }
}

