package com.digiwin.athena.framework.jsoni18n;

import com.digiwin.athena.framework.jsoni18n.annotation.JsonI18nFormat;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;

import java.util.Map;

public class I18nAnnotationIntrospector extends JacksonAnnotationIntrospector {

    @Override
    public Object findSerializer(Annotated a) {
        if (a.hasAnnotation(JsonI18nFormat.class)) {
            return new I18nStringSerializer();
        } else if (Map.class.isAssignableFrom(a.getRawType())) {
            return I18nMapSerializer.class;
        }
        return super.findSerializer(a);
    }
}

