package com.digiwin.athena.framework.jsoni18n;

import com.digiwin.athena.framework.jsoni18n.utils.I18nUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;
import java.io.IOException;
import java.util.Map;

public class I18nMapSerializer extends JsonSerializer<Map<String, Object>> {

    @Override
    public void serialize(Map<String, Object> value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        String locale = LocaleContextHolder.getLocale().toString();

        for (Map.Entry<String, Object> entry : value.entrySet()) {
            Object fieldValue = entry.getValue();
            if (fieldValue instanceof String) {
                // 处理字符串类型的国际化
                String localizedValue = I18nUtils.extractLocalizedValue((String) fieldValue, locale);
                if (StringUtils.isBlank(localizedValue)) {
                    localizedValue = (String) fieldValue;
                }
                gen.writeStringField(entry.getKey(), localizedValue);
            } else if (fieldValue instanceof Map) {
                // 递归处理嵌套的 Map
                gen.writeFieldName(entry.getKey());
                serialize((Map<String, Object>) fieldValue, gen, serializers);
            } else {
                // 其他类型直接写入
                gen.writeObjectField(entry.getKey(), fieldValue);
            }
        }
        gen.writeEndObject();
    }


}
