/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.jsoni18n;

import com.digiwin.athena.framework.jsoni18n.utils.I18nUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

public class I18nStringSerializer
extends JsonSerializer<String> {
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        String locale = LocaleContextHolder.getLocale().toString();
        String localizedValue = I18nUtils.extractLocalizedValue(value, locale);
        if (StringUtils.isBlank((CharSequence)localizedValue)) {
            localizedValue = value;
        }
        gen.writeString(localizedValue);
    }
}

