package com.digiwin.athena.framework.jsoni18n;

import com.digiwin.athena.framework.jsoni18n.utils.I18nUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.i18n.LocaleContextHolder;

import java.io.IOException;

public class I18nStringSerializer extends JsonSerializer<String> {

    @Override
    public void serialize(String value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        // 获取当前语言环境,没有则使用系统的默认语言环境
        String locale = LocaleContextHolder.getLocale().toString();
        // 使用正则表达式匹配特定的 locale 字符串，例如 "zh_CN" 和 "en_US"
        String localizedValue = I18nUtils.extractLocalizedValue(value, locale);
        //如果默认语言还为空，则取原值
        if (StringUtils.isBlank(localizedValue)) {
            localizedValue = value;
        }
        gen.writeString(localizedValue);
    }

//    public static void main(String[] args) {
//        String json = "{\"zh_TW\":\"手動任務\",\"en_US\":\"manual assignment\",\"zh_CN\":\"手动任务\"}";
//        System.out.println(json);
//        System.out.println("Locale zh_CN: " + I18nUtils.extractLocalizedValue(json, "zh_CN"));
//        System.out.println("Locale en_US: " + I18nUtils.extractLocalizedValue(json, "en_US"));
//        System.out.println("Locale zh_TW: " + I18nUtils.extractLocalizedValue(json, "zh_TW"));
//    }
}
