package com.digiwin.athena.framework.jsoni18n.processor;

import com.digiwin.athena.framework.jsoni18n.I18nAnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class JsonI18nBeanPostProcessor implements BeanPostProcessor {

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MappingJackson2HttpMessageConverter) {
            MappingJackson2HttpMessageConverter converter = (MappingJackson2HttpMessageConverter) bean;
            ObjectMapper objectMapper = converter.getObjectMapper();
            objectMapper.setAnnotationIntrospector(new I18nAnnotationIntrospector());
        }
        return bean;
    }
}
