package com.digiwin.athena.framework.jsoni18n.utils;

import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

@Slf4j
public class I18nUtils {

    /**
     * 判断是否是json格式
     *
     * @param jsonStr
     * @return
     */
    public static boolean isValidJson(String jsonStr) {
        if (StringUtils.isBlank(jsonStr)) {
            return Boolean.FALSE;
        }
        String jsonPattern = "\\A\\{.*}|\\[.*]}\\z";
        return jsonStr.trim().matches(jsonPattern);
    }

    /**
     * 抽取出指定语言环境的字符串
     *
     * @param json
     * @param locale
     * @return
     */
    public static String extractLocalizedValue(String json, String locale) {
        if (StringUtils.isBlank(json)) {
            return json;
        }
        try {
            // 转义特殊字符
            String jsonStr = StringEscapeUtils.unescapeJava(json);
            // 将 JSON 字符串解析为 JSONObject
            JSONObject jsonObject = JSONObject.parseObject(jsonStr);
            // 根据 locale 获取对应的值
            return jsonObject.getString(locale);
        } catch (Exception e) {
            log.warn("extractLocalizedValue error", e);
        }
        return null;
    }
//    /**
//     * 从 JSON 字符串中提取指定 locale 的国际化值
//     */
//    public String extractLocalizedValue(String json, String locale) {
//        if (StringUtils.isBlank(json)) {
//            return json;
//        }
//        String jsonStr = StringEscapeUtils.unescapeJava(json);
//        String pattern = "\"" + locale + "\"\\s*:\\s*\"(.*?)\"";
//        Pattern regex = Pattern.compile(pattern);
//        Matcher matcher = regex.matcher(jsonStr);
//        if (matcher.find()) {
//            return matcher.group(1);
//        }
//        return null;
//    }
}
