/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.jsonview.advice;

import com.digiwin.athena.framework.jsonview.annotation.DynamicJsonView;
import com.digiwin.athena.framework.jsonview.filter.DynamicBeanPropertyFilterBean;
import com.digiwin.athena.framework.jsonview.filter.DynamicFilterProvider;
import com.digiwin.athena.framework.jsonview.resolver.DynamicFilterResolver;
import com.digiwin.athena.framework.jsonview.resolver.FilterIgnoreResolver;
import com.digiwin.athena.framework.jsonview.resolver.FilterIncloudResolver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonValue;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.AbstractMappingJacksonResponseBodyAdvice;

public class DynamicFilterResponseBodyAdvice
extends AbstractMappingJacksonResponseBodyAdvice {
    private static final String JSON_VIEW_HEADER = "digi-json-view";
    protected final Map<Class, DynamicFilterResolver> resolvers = new HashMap<Class, DynamicFilterResolver>();

    public DynamicFilterResponseBodyAdvice() {
        this.addResolvers(new FilterIgnoreResolver(), new FilterIncloudResolver());
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        return super.supports(returnType, converterType) && this.isSupport(returnType);
    }

    protected void beforeBodyWriteInternal(MappingJacksonValue bodyContainer, MediaType contentType, MethodParameter returnType, ServerHttpRequest request, ServerHttpResponse response) {
        this.resolveFilter(returnType).map(DynamicFilterProvider::new).ifPresent(arg_0 -> ((MappingJacksonValue)bodyContainer).setFilters(arg_0));
    }

    public void addResolvers(DynamicFilterResolver resolver, DynamicFilterResolver ... more) {
        this.resolvers.put(resolver.getClass(), resolver);
        Stream.of(more).filter(Objects::nonNull).forEach(r -> this.resolvers.put(resolver.getClass(), (DynamicFilterResolver)r));
    }

    protected Optional<DynamicBeanPropertyFilterBean> resolveFilter(MethodParameter returnType) {
        DynamicJsonView dynamicView = this.getSupportDynamicJsonView(returnType);
        return this.resolvers.values().stream().map(resolver -> resolver.resolve(dynamicView)).filter(Objects::nonNull).findFirst();
    }

    private boolean isSupport(MethodParameter returnType) {
        String jsonView = this.getCurrentViewFromHeader();
        if (StringUtils.isEmpty((Object)jsonView)) {
            return false;
        }
        DynamicJsonView[] annotations = (DynamicJsonView[])returnType.getMethod().getAnnotationsByType(DynamicJsonView.class);
        if (annotations == null || annotations.length == 0) {
            return false;
        }
        Arrays.stream(annotations).forEach(this::validator);
        return Arrays.stream(annotations).anyMatch(annotation -> annotation.viewName().equals(jsonView));
    }

    private DynamicJsonView getSupportDynamicJsonView(MethodParameter returnType) {
        String jsonView = this.getCurrentViewFromHeader();
        DynamicJsonView[] annotations = (DynamicJsonView[])returnType.getMethod().getAnnotationsByType(DynamicJsonView.class);
        return Arrays.stream(annotations).filter(annotation -> annotation.viewName().equals(jsonView)).findFirst().orElse(null);
    }

    private String getCurrentViewFromHeader() {
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (attrs != null) {
            HttpServletRequest request = attrs.getRequest();
            return request.getHeader(JSON_VIEW_HEADER);
        }
        return null;
    }

    private void validator(DynamicJsonView dynamicView) {
        if (dynamicView != null) {
            String[] ignoreFields = dynamicView.ignoreFields();
            String[] includeFields = dynamicView.includeFields();
            if (ignoreFields.length > 0 && includeFields.length > 0) {
                throw new IllegalArgumentException("DynamicJsonView cannot have both ignoreFields and includeFields set at the same time.");
            }
        }
    }
}

