package com.digiwin.athena.framework.jsonview;

import com.digiwin.athena.framework.jsonview.processor.DynamicFilterBeanPostProcessor;
import com.digiwin.athena.framework.jsonview.processor.DynamicFilterResponseBodyAdvicePostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


@Configuration
@ConditionalOnProperty(prefix = "athena.boot.jsonview", name = "enable", havingValue = "true") // 配置项为 true 时启用
public class JsonViewAotoConfiguration {

    @Bean
    public DynamicFilterResponseBodyAdvicePostProcessor requestMappingHandlerAdapterPostProcessor() {
        DynamicFilterResponseBodyAdvicePostProcessor processor = new DynamicFilterResponseBodyAdvicePostProcessor();
        return processor;
    }


    @Bean
    public DynamicFilterBeanPostProcessor jacksonMessageConverterBeanPostProcessor() {
        DynamicFilterBeanPostProcessor processor = new DynamicFilterBeanPostProcessor();
        return processor;
    }
}
