package com.digiwin.athena.framework.jsonview.processor;


import com.digiwin.athena.framework.jsonview.filter.DynamicFilterMixIn;
import com.digiwin.athena.framework.jsonview.filter.DynamicFilterProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;

public class DynamicFilterBeanPostProcessor implements BeanPostProcessor {

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MappingJackson2HttpMessageConverter) {
            MappingJackson2HttpMessageConverter converter = (MappingJackson2HttpMessageConverter) bean;
            ObjectMapper objectMapper = converter.getObjectMapper();
            enhanceObjectMapper(objectMapper);
        }
        return bean;
    }

    private void enhanceObjectMapper(ObjectMapper objectMapper) {
        // 添加 MixIn 配置
        objectMapper.addMixIn(Object.class, DynamicFilterMixIn.class);
        // 设置过滤器
        objectMapper.setFilterProvider(new DynamicFilterProvider());
    }

}
