package com.digiwin.athena.framework.jsonview.processor;

import com.digiwin.athena.framework.jsonview.advice.DynamicFilterResponseBodyAdvice;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import java.util.Collections;

public class DynamicFilterResponseBodyAdvicePostProcessor implements BeanPostProcessor {

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        if (bean instanceof RequestMappingHandlerAdapter) {
            RequestMappingHandlerAdapter adapter = (RequestMappingHandlerAdapter) bean;
            adapter.setResponseBodyAdvice(Collections.singletonList(new DynamicFilterResponseBodyAdvice()));
        }
        return bean;
    }
}