package com.digiwin.athena.framework.jsonview.annotation;

import java.lang.annotation.*;

/**
 * jackson动态视图注解
 *
 * @author zhuanghq
 */
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Repeatable(DynamicJsonViews.class)
public @interface DynamicJsonView {
    /**
     * 用于指定视图名称
     *
     * @return
     */
    String viewName();

    /**
     * 定义该视图下需要忽略的字段
     *
     * @return
     */
    String[] ignoreFields() default {};

    /**
     * 定义该视图下需要包含的字段
     *
     * @return
     */
    String[] includeFields() default {};
}
