package com.digiwin.athena.framework.jsonview.resolver;

import com.digiwin.athena.framework.jsonview.annotation.DynamicJsonView;
import com.digiwin.athena.framework.jsonview.filter.DynamicBeanPropertyFilterBean;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;

/**
 * 针对包含属性的过滤器
 *
 * @author zhuanghq
 */
public class FilterIncloudResolver extends DynamicFilterResolver {

    @Override
    public DynamicBeanPropertyFilterBean apply(DynamicJsonView annotation) {
        String[] includeFields = annotation.includeFields();
        if (includeFields == null || includeFields.length == 0) {
            return null;
        }
        SimpleBeanPropertyFilter filter = SimpleBeanPropertyFilter.filterOutAllExcept(includeFields);
        DynamicBeanPropertyFilterBean bean = new DynamicBeanPropertyFilterBean(filter);
        bean.setIncludeFields(includeFields);
        return bean;
    }

}
