package com.digiwin.athena.framework.jsonview.resolver;

import com.digiwin.athena.framework.jsonview.filter.DynamicBeanPropertyFilterBean;
import com.digiwin.athena.framework.jsonview.annotation.DynamicJsonView;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;

/**
 * 针对忽略属性的过滤器
 *
 * @author zhuanghq
 */
public class FilterIgnoreResolver extends DynamicFilterResolver {

    @Override
    public DynamicBeanPropertyFilterBean apply(DynamicJsonView annotation) {
        String[] ignoreFields = annotation.ignoreFields();
        if (ignoreFields == null || ignoreFields.length == 0) {
            return null;
        }
        SimpleBeanPropertyFilter filter = SimpleBeanPropertyFilter.serializeAllExcept(ignoreFields);
        DynamicBeanPropertyFilterBean bean = new DynamicBeanPropertyFilterBean(filter);
        bean.setIgnoreFields(ignoreFields);
        return bean;
    }

}
