package com.digiwin.athena.framework.jsonview.resolver;

import com.digiwin.athena.framework.jsonview.filter.DynamicBeanPropertyFilterBean;
import com.digiwin.athena.framework.jsonview.annotation.DynamicJsonView;

import java.util.Optional;
import java.util.function.Function;


public abstract class DynamicFilterResolver implements Function<DynamicJsonView, DynamicBeanPropertyFilterBean> {

    @SuppressWarnings("unchecked")
    public final DynamicBeanPropertyFilterBean resolve(DynamicJsonView dynamicView) {
        return Optional.ofNullable(dynamicView).map(this::apply).orElse(null);
    }
}
