package com.digiwin.athena.framework.jsonview.filter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;

import static java.util.Objects.requireNonNull;

/**
 * 属性过滤
 *
 * @author zhuanghq
 */
public class DynamicFilterProvider extends SimpleFilterProvider implements PropertyFilter {

    public static final String FILTER_ID = "DynamicFilterProvider$FILTER";
    private static final long serialVersionUID = 1L;

    private final PropertyFilter delegate;

    private final ExpressionParser parser = new SpelExpressionParser();

    public DynamicFilterProvider() {
        this(SimpleBeanPropertyFilter.serializeAll());
    }

    public DynamicFilterProvider(DynamicBeanPropertyFilterBean bean) {
        this.delegate = requireNonNull(bean.getFilter());
        addFilter(FILTER_ID, this);
    }

    public DynamicFilterProvider(PropertyFilter delegate) {
        this.delegate = requireNonNull(delegate);
        addFilter(FILTER_ID, this);
    }

    @Override
    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
        //普通无注解对象判断
        delegate.serializeAsField(pojo, jgen, prov, writer);
    }

    @Override
    public void serializeAsElement(Object elementValue, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
        delegate.serializeAsElement(elementValue, jgen, prov, writer);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void depositSchemaProperty(PropertyWriter writer, ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
        delegate.depositSchemaProperty(writer, propertiesNode, provider);
    }

    @Override
    public void depositSchemaProperty(PropertyWriter writer, JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        delegate.depositSchemaProperty(writer, objectVisitor, provider);
    }

}
