/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.lmc;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class DwLmcKafkaProcessor {
    private static Producer<String, String> producer;

    private DwLmcKafkaProcessor() {
    }

    public static Producer<String, String> getProducer() {
        return producer;
    }

    public static void init() {
        DwLmcKafkaProcessor.createProducer();
    }

    private static void createProducer() {
        Properties kafkaProperties;
        Map configMap = JaYamlProcessor.getProperties((Map)JaProperty.getPropertyMap(), (String)"ja.kafka.producer");
        if (JaCollectionUtil.isNotEmpty((Map)configMap) && null != (kafkaProperties = (Properties)configMap.get("lmc")) && JaProperty.getBoolean((String)"ja.kafka.producer.lmc.enabled", (Boolean)false).booleanValue()) {
            producer = new KafkaProducer(kafkaProperties);
        }
    }

    static {
        JaShutdownHookUtil.add((String)"lmc-kafka-producer", () -> {
            if (null != producer) {
                producer.close();
            }
        });
        JaPropertyListener.addCommonListener(() -> {
            if (JaProperty.getBoolean((String)"ja.kafka.producer.lmc.enabled", (Boolean)false).booleanValue() && JaProperty.getBoolean((String)"ja.kafka.producer.lmc.recreate", (Boolean)false).booleanValue()) {
                if (null != producer) {
                    producer.close();
                }
                DwLmcKafkaProcessor.createProducer();
            }
        });
    }
}

