package com.digiwin.athena.framework.lmc;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.config.processor.JaYamlProcessor;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.kafka.producer.JaKafkaProducerProcessor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

import java.util.Map;
import java.util.Properties;

/**
 * lmc kafka 推送
 *
 * @author chenjian
 * @since 2025年08月27日 21:24:54
 */
public class DwLmcKafkaProcessor {

    private DwLmcKafkaProcessor() {
    }

    private static Producer<String, String> producer;

    public static Producer<String, String> getProducer() {
        return producer;
    }

    static {
        JaShutdownHookUtil.add("lmc-kafka-producer", () -> {
            if (null != producer) {
                producer.close();
            }
        });
        JaPropertyListener.addCommonListener(() -> {
            if (JaProperty.getBoolean("ja.kafka.producer.lmc.enabled", false)
                    // 调优之后要改回false
                    && JaProperty.getBoolean("ja.kafka.producer.lmc.recreate", false)
            ) {
                if (null != producer) {
                    producer.close();
                }
                createProducer();
            }

        });
    }

    public static void init() {
        createProducer();
//        JaDapperLog.setReqLogHandler((size, json, nodeSpan) -> {
//
//        });
//        JaDapperLog.setRespLogHandler((size, json, respSpan) -> {
//
//        });
    }


    private static void createProducer() {
        Map<String, Properties> configMap = JaYamlProcessor.getProperties(JaProperty.getPropertyMap(), "ja.kafka.producer");
        if (JaCollectionUtil.isNotEmpty(configMap)) {
            Properties kafkaProperties = configMap.get("lmc");
            if (null != kafkaProperties && JaProperty.getBoolean("ja.kafka.producer.lmc.enabled", false)) {
                producer = new KafkaProducer<>(JaKafkaProducerProcessor.wrapProperties(kafkaProperties));
            }

        }
    }
}
