/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.lmc.appender;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.digiwin.dap.middleware.lmc.common.TimeingSingletonEnum;
import com.digiwin.dap.middleware.lmc.internal.LMCResourceUri;
import com.digiwin.dap.middleware.lmc.util.LogUtils;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.json.JSONArray;

public class DwLogbackAppender<E>
extends UnsynchronizedAppenderBase<E> {
    public static final int PERIOD_MILL_SECONDS = 2000;
    private SimpleDateFormat _sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    public static final int QUEUE_SIZE = 50;
    private static final Queue<Map<String, Object>> QUEUE = new LinkedBlockingQueue<Map<String, Object>>(50);
    private CloseableHttpClient client;
    private String app;
    private String endpoint;
    protected Encoder<E> encoder;
    private String userAgent = "logback";
    public static boolean IsStop = false;

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.addError("Failed to start LoghubAppender.", e);
        }
    }

    private void doStart() {
        super.start();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(5000).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setMaxTotal(4);
        connectionManager.setDefaultMaxPerRoute(4);
        connectionManager.setValidateAfterInactivity(2000);
        this.client = HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).build();
        this.initInsertQueueTask();
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.addError("Failed to stop LoghubAppender.", e);
        }
    }

    private void doStop() {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException var2) {
                this.addError(var2.getMessage());
            }
        }
    }

    public void append(E eventObject) {
        if (IsStop || JaEnvProperty.isLocal()) {
            return;
        }
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    private void appendEvent(E eventObject) {
        String ptxId;
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        Map mdcPropertyMap = event.getMDCPropertyMap();
        String traceId = !mdcPropertyMap.isEmpty() ? ((ptxId = (String)mdcPropertyMap.get("PtxId")) != null && !"".equals(ptxId) ? ptxId : LogUtils.getUUID()) : LogUtils.getUUID();
        logMap.putIfAbsent("traceId", traceId);
        HashMap initMap = new HashMap();
        LogUtils.initLogMap(initMap);
        logMap.putAll(initMap);
        logMap.putIfAbsent("appId", this.getApp());
        logMap.putIfAbsent("time", this._sdf.format(new Date()));
        logMap.putIfAbsent("level", event.getLevel().toString());
        logMap.putIfAbsent("thread", event.getThreadName());
        logMap.putIfAbsent("loggerName", event.getLoggerName());
        String addr = LogUtils.getLocalHostIpName();
        logMap.putIfAbsent("source", addr);
        logMap.putIfAbsent("appender", "DwLogbackAppender");
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            logMap.putIfAbsent("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        logMap.putIfAbsent("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            String throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = throwable + this.fullDump(event.getThrowableProxy().getStackTraceElementProxyArray());
            logMap.putIfAbsent("throwable", throwable);
        }
        if (this.encoder != null) {
            logMap.putIfAbsent("log", new String(this.encoder.encode(eventObject)));
        }
        if (QUEUE.offer(logMap)) {
            return;
        }
        this.insertQueue(logMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertQueue(Map<String, Object> logMap) {
        if (IsStop) {
            return;
        }
        if (logMap == null) {
            boolean executable;
            boolean bl = executable = System.currentTimeMillis() - TimeingSingletonEnum.getInstance().getExecutionTimeMs() > 2000L && !QUEUE.isEmpty();
            if (!executable) {
                return;
            }
        }
        ArrayList<Map<String, Object>> insertList = new ArrayList<Map<String, Object>>(QUEUE);
        QUEUE.clear();
        TimeingSingletonEnum.getInstance().setExecutionTimeMs(System.currentTimeMillis());
        Optional.ofNullable(logMap).ifPresent(QUEUE::offer);
        if (insertList.isEmpty()) {
            return;
        }
        CloseableHttpResponse hResponse = null;
        HttpPost postMethod = new HttpPost(LMCResourceUri.getSaveDevLogBatchUrl((String)this.endpoint));
        try {
            JSONArray tmepObjects = new JSONArray(insertList);
            String formatValue = tmepObjects.toString();
            postMethod.setEntity((HttpEntity)new StringEntity(formatValue, ContentType.APPLICATION_JSON));
            hResponse = this.client.execute((HttpUriRequest)postMethod);
            HttpEntity repEntity = hResponse.getEntity();
            int statusCode = hResponse.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                postMethod.abort();
            }
        }
        catch (Exception e) {
            this.addError(e.getMessage());
        }
        finally {
            if (hResponse != null) {
                try {
                    hResponse.close();
                }
                catch (IOException e) {
                    this.addError(e.getMessage());
                }
            }
        }
    }

    private void initInsertQueueTask() {
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(() -> this.insertQueue(null), 0L, 2000L, TimeUnit.MILLISECONDS);
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

