/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.lmc;

import com.digiwin.athena.framework.lmc.meta.DwLmcEntity;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.log.JaDapperLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaDateUtil;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.kafka.producer.JaKafkaProducerProcessor;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class DwLmcKafkaProcessor {
    private static final String handlerNameReq = "log-kafka-req";
    private static final String handlerNameResp = "log-kafka-resp";
    private static Producer<String, String> producer;

    private DwLmcKafkaProcessor() {
    }

    public static Producer<String, String> getProducer() {
        return producer;
    }

    public static void init() {
        DwLmcKafkaProcessor.createProducer();
        if (null != producer) {
            JaDapperLog.getReqLogHandlerMap().put(handlerNameReq, (size, json, nodeSpan) -> {
                DwLmcEntity dwLmcEntity = DwLmcKafkaProcessor.createDwLmcEntity(nodeSpan, size);
                dwLmcEntity.setTime(JaDateUtil.stringTime((Long)nodeSpan.getTimestamp(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"}));
                dwLmcEntity.setType("req");
                dwLmcEntity.setMessage((String)json);
            });
            JaDapperLog.getRespLogHandlerMap().put(handlerNameResp, (size, json, respSpan) -> {
                NodeSpan nodeSpan = respSpan.getNodeSpan();
                DwLmcEntity dwLmcEntity = DwLmcKafkaProcessor.createDwLmcEntity(nodeSpan, size);
                dwLmcEntity.setTime(JaDateUtil.stringTime((Long)respSpan.getEnd(), (String[])new String[]{"yyyy-MM-dd HH:mm:ss.SSS"}));
                dwLmcEntity.setType("resp");
                dwLmcEntity.setTimeConsume(respSpan.getEnd() - nodeSpan.getTimestamp() + "");
                Throwable throwable = respSpan.getThrowable();
                dwLmcEntity.setMessage((String)json);
                if (null == throwable) {
                    dwLmcEntity.setMessage((String)json);
                    dwLmcEntity.setLevel("ERROR");
                } else {
                    dwLmcEntity.setThrowable((String)json);
                }
            });
        }
    }

    private static void createProducer() {
        Properties kafkaProperties;
        Map propertiesMap = JaKafkaProducerProcessor.getPropertiesMap();
        if (JaCollectionUtil.isNotEmpty((Map)propertiesMap) && null != (kafkaProperties = (Properties)propertiesMap.get("lmc")) && JaProperty.getBoolean((String)"ja.kafka.producer.lmc.enabled", (Boolean)false).booleanValue()) {
            producer = new KafkaProducer(JaKafkaProducerProcessor.wrapProperties((Properties)kafkaProperties));
        }
    }

    private static DwLmcEntity createDwLmcEntity(NodeSpan nodeSpan, Long size) {
        DwLmcEntity dwLmcEntity = new DwLmcEntity();
        dwLmcEntity.setAppId(JaEnvProperty.getApplicationName());
        dwLmcEntity.setAppName(JaEnvProperty.getApplicationName());
        dwLmcEntity.setSource(JaEnvProperty.getEntity().getPodName());
        dwLmcEntity.setThread(nodeSpan.getThreadName());
        dwLmcEntity.setAppender("jugg-kafka");
        dwLmcEntity.setTraceId(JaMDC.get());
        dwLmcEntity.setSpanId(JaMDC.getRequestId());
        dwLmcEntity.setLevel("INFO");
        dwLmcEntity.setLoggerName("ja.dapper");
        dwLmcEntity.setNodeType(nodeSpan.getNodeKind().getKind());
        dwLmcEntity.setType("resp");
        dwLmcEntity.setNodeId(nodeSpan.getId());
        dwLmcEntity.setCurrentNodeSpanId(nodeSpan.getRequestId());
        dwLmcEntity.setParamSize(size + "");
        return dwLmcEntity;
    }

    static {
        JaShutdownHookUtil.add((String)"lmc-kafka-producer", () -> {
            if (null != producer) {
                producer.close();
            }
        });
        JaPropertyListener.addCommonListener(() -> {
            if (JaProperty.getBoolean((String)"ja.kafka.producer.lmc.enabled", (Boolean)false).booleanValue() && JaProperty.getBoolean((String)"ja.kafka.producer.lmc.recreate", (Boolean)false).booleanValue()) {
                if (null != producer) {
                    producer.close();
                    JaDapperLog.getReqLogHandlerMap().remove(handlerNameReq);
                    JaDapperLog.getRespLogHandlerMap().remove(handlerNameResp);
                }
                DwLmcKafkaProcessor.createProducer();
            }
        });
    }
}

