package com.digiwin.athena.framework.lmc;

import com.digiwin.athena.framework.lmc.meta.DwLmcEntity;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaPropertyListener;
import com.jugg.agile.framework.core.dapper.log.JaDapperLog;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.core.dapper.meta.NodeSpan;
import com.jugg.agile.framework.core.util.JaDateUtil;
import com.jugg.agile.framework.core.util.JaShutdownHookUtil;
import com.jugg.agile.framework.core.util.datastructure.JaCollectionUtil;
import com.jugg.agile.middleware.kafka.producer.JaKafkaProducerProcessor;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

import java.util.Map;
import java.util.Properties;

/**
 * lmc kafka 推送
 *
 * @author chenjian
 * @since 2025年08月27日 21:24:54
 */
public class DwLmcKafkaProcessor {

    private DwLmcKafkaProcessor() {
    }

    private static final String handlerNameReq = "log-kafka-req";
    private static final String handlerNameResp = "log-kafka-resp";

    private static Producer<String, String> producer;

    public static Producer<String, String> getProducer() {
        return producer;
    }

    static {
        JaShutdownHookUtil.add("lmc-kafka-producer", () -> {
            if (null != producer) {
                producer.close();
            }
        });
        JaPropertyListener.addCommonListener(() -> {
            if (JaProperty.getBoolean("ja.kafka.producer.lmc.enabled", false)
                    // 调优之后要改回false
                    && JaProperty.getBoolean("ja.kafka.producer.lmc.recreate", false)
            ) {
                if (null != producer) {
                    producer.close();
                    JaDapperLog.getReqLogHandlerMap().remove(handlerNameReq);
                    JaDapperLog.getRespLogHandlerMap().remove(handlerNameResp);
                }
                createProducer();
            }

        });
    }

    public static void init() {
        createProducer();
        if (null != producer) {
            JaDapperLog.getReqLogHandlerMap().put(handlerNameReq, (size, json, nodeSpan) -> {
                DwLmcEntity dwLmcEntity = createDwLmcEntity(nodeSpan, size);
                dwLmcEntity.setTime(JaDateUtil.stringTime(nodeSpan.getTimestamp(), JaDateUtil.Pattern_2));
                dwLmcEntity.setType("req");
                dwLmcEntity.setMessage(json);
            });
            JaDapperLog.getRespLogHandlerMap().put(handlerNameResp, (size, json, respSpan) -> {
                NodeSpan nodeSpan = respSpan.getNodeSpan();
                DwLmcEntity dwLmcEntity = createDwLmcEntity(nodeSpan, size);
                dwLmcEntity.setTime(JaDateUtil.stringTime(respSpan.getEnd(), JaDateUtil.Pattern_2));
                dwLmcEntity.setType("resp");
                dwLmcEntity.setTimeConsume((respSpan.getEnd() - nodeSpan.getTimestamp()) + "");
                Throwable throwable = respSpan.getThrowable();
                dwLmcEntity.setMessage(json);
                if (null == throwable) {
                    dwLmcEntity.setMessage(json);
                    dwLmcEntity.setLevel("ERROR");
                } else {
                    dwLmcEntity.setThrowable(json);
                }
            });
        }
    }


    private static void createProducer() {
        Map<String, Properties> propertiesMap = JaKafkaProducerProcessor.getPropertiesMap();
        if (JaCollectionUtil.isNotEmpty(propertiesMap)) {
            Properties kafkaProperties = propertiesMap.get("lmc");
            if (null != kafkaProperties && JaProperty.getBoolean("ja.kafka.producer.lmc.enabled", false)) {
                producer = new KafkaProducer<>(JaKafkaProducerProcessor.wrapProperties(kafkaProperties));
            }

        }
    }

    private static DwLmcEntity createDwLmcEntity(NodeSpan nodeSpan, Long size) {
        DwLmcEntity dwLmcEntity = new DwLmcEntity();
        dwLmcEntity.setAppId(JaEnvProperty.getApplicationName());
        dwLmcEntity.setAppName(JaEnvProperty.getApplicationName());
        dwLmcEntity.setSource(JaEnvProperty.getEntity().getPodName());
        dwLmcEntity.setThread(nodeSpan.getThreadName());
        dwLmcEntity.setAppender("jugg-kafka");
        dwLmcEntity.setTraceId(JaMDC.get());
        dwLmcEntity.setSpanId(JaMDC.getRequestId());
        dwLmcEntity.setLevel("INFO");
        dwLmcEntity.setLoggerName("ja.dapper");
        dwLmcEntity.setNodeType(nodeSpan.getNodeKind().getKind());
        dwLmcEntity.setType("resp");
        dwLmcEntity.setNodeId(nodeSpan.getId());
        dwLmcEntity.setCurrentNodeSpanId(nodeSpan.getRequestId());
        dwLmcEntity.setParamSize(size + "");
        return dwLmcEntity;
    }
}
