package com.digiwin.athena.framework.lmc.config;

import com.digiwin.athena.framework.lmc.DwLmcKafkaProcessor;
import com.jugg.agile.framework.core.config.JaCenterPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.JaUUID;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigPropertiesProcessor;
import com.jugg.agile.middleware.nacos.config.JaNacosConfigService;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class DwLmcPropertyHandler implements JaCenterPropertyHandler {

    @Override
    public void addAndCover() {
        JaNacosConfigService.loadYaml("lmc.yml", JaNacosConfigPropertiesProcessor.getNameSpaceCommon());
        DwLmcKafkaProcessor.init();
    }

    public static void main(String[] args) {
        JaProperty.put("ja.kafka.producer.lmc.enabled", true);
        JaProperty.put("ja.kafka.producer.lmc.bootstrap.servers", "localhost:9092");
        JaProperty.put("ja.kafka.producer.lmc.acks", 0);
        JaProperty.put("ja.kafka.producer.lmc.retries", 0);
        new DwLmcPropertyHandler().addAndCover();
        ProducerRecord<String, String> record = new ProducerRecord<>("test-topic", JaUUID.UUID19(), "test log");
        DwLmcKafkaProcessor.getProducer().send(record);

    }
}
