/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.exception;

import com.jugg.agile.framework.meta.adapter.JaI18nAdapter;
import com.jugg.agile.framework.meta.exception.JaBaseException;
import java.util.Map;
import java.util.Objects;

public class BusinessException
extends JaBaseException {
    Integer code;
    private Integer status;
    private String statusDescription;
    private String errorCode;
    private Object errorMessage;
    private String errorType;
    @Deprecated
    private Map<String, Object> errorInstructors;
    @Deprecated
    private String description;
    private boolean wrapper;
    private String bizErrorCode;
    private String bizErrorMsg;
    private Map<String, Object> espError;

    public static BusinessException create(Integer code, String errorCode, Object errorMessage, String description, String statusDescription, Throwable e) {
        return BusinessException.create(500, errorCode, errorMessage, description, statusDescription, null, null);
    }

    public static BusinessException create(Integer code, String errorCode, Object errorMessage, String description, String statusDescription, String errorType, Throwable e) {
        BusinessException businessException = new BusinessException(description, e);
        BusinessException.wrap(businessException, code, errorCode, errorMessage, description, statusDescription, errorType);
        return businessException;
    }

    public static void wrap(BusinessException businessException, Integer code, String errorCode, Object errorMessage, String description, String statusDescription, String errorType) {
        businessException.setCode(code);
        businessException.setErrorCode(errorCode);
        if (Objects.isNull(errorMessage)) {
            String local = JaI18nAdapter.getLocale();
            errorMessage = "\u9875\u9762\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\uff01";
            if (Objects.equals(local, "zh_TW") || Objects.equals(local, "zh-TW")) {
                errorMessage = "\u9801\u9762\u51fa\u73fe\u7570\u5e38\uff0c\u8acb\u806f\u7cfb\u5ba2\u670d\uff01";
            }
            if (Objects.equals(local, "en_US") || Objects.equals(local, "en-US")) {
                errorMessage = "The page is abnormal, please contact customer service!";
            }
        }
        businessException.setErrorType(errorType);
        businessException.setErrorMessage(errorMessage);
        businessException.setDescription(description);
        businessException.setStatusDescription(statusDescription);
    }

    public BusinessException() {
    }

    public static BusinessException create(String message) {
        return BusinessException.create(500, null, message, message, "", null);
    }

    public static BusinessException create(Throwable cause) {
        return BusinessException.create(500, null, null, cause.getMessage(), "", cause);
    }

    public static BusinessException create(Integer code, String message) {
        return BusinessException.create(code, code.toString(), message, message, "", null);
    }

    public static BusinessException create(String errorCode, String message) {
        return BusinessException.create(500, errorCode, message, message, "", null);
    }

    public static BusinessException create(String errorCode, String message, String errorType) {
        return BusinessException.create(500, errorCode, message, message, "", errorType, null);
    }

    public static BusinessException create(String errorCode, String message, String errorType, Throwable cause) {
        return BusinessException.create(500, errorCode, message, message, "", errorType, cause);
    }

    public static BusinessException create(String errorCode, String message, Throwable cause) {
        return BusinessException.create(500, errorCode, message, message, "", cause);
    }

    public static BusinessException create(Integer code, String errorCode, String message) {
        return BusinessException.create(code, errorCode, message, message, "", null);
    }

    public static BusinessException create(Integer code, String errorCode, String message, Throwable cause) {
        return BusinessException.create(code, errorCode, message, message, "", cause);
    }

    public static BusinessException create(String message, Throwable cause) {
        return BusinessException.create(500, null, message, message, "", cause);
    }

    public static BusinessException create(Integer errorCode, String message, Throwable cause) {
        return BusinessException.create(500, errorCode.toString(), message, message, "", cause);
    }

    public static BusinessException buildErrorCode(String errorCode) {
        BusinessException businessException = new BusinessException();
        businessException.setCode(500);
        businessException.setErrorCode(errorCode);
        return businessException;
    }

    public static BusinessException buildBizErrorCode(String errorCode) {
        BusinessException businessException = new BusinessException();
        businessException.setCode(500);
        businessException.setErrorCode(errorCode);
        businessException.setBizErrorCode(errorCode);
        return businessException;
    }

    public BusinessException(Throwable cause) {
        super(cause);
    }

    public BusinessException(String errorCode, String errorMessage) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public Integer getCode() {
        return this.code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    public BusinessException(String message) {
        super(message);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isWrapper() {
        return this.wrapper;
    }

    public void setWrapper(boolean wrapper) {
        this.wrapper = wrapper;
    }

    @Deprecated
    public Map<String, Object> getErrorInstructors() {
        return this.errorInstructors;
    }

    @Deprecated
    public void setErrorInstructors(Map<String, Object> errorInstructors) {
        this.errorInstructors = errorInstructors;
    }

    public String getBizErrorCode() {
        return this.bizErrorCode;
    }

    public void setBizErrorCode(String bizErrorCode) {
        this.bizErrorCode = bizErrorCode;
    }

    public String getBizErrorMsg() {
        return this.bizErrorMsg;
    }

    public void setBizErrorMsg(String bizErrorMsg) {
        this.bizErrorMsg = bizErrorMsg;
    }

    public Map<String, Object> getEspError() {
        return this.espError;
    }

    public void setEspError(Map<String, Object> espError) {
        this.espError = espError;
    }
}

