/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.appcore.domain;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jugg.agile.framework.meta.JaMetaUtil;
import com.jugg.agile.framework.meta.adapter.JaCoreAdapter;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import java.util.Map;

public class BaseResultDTO<T>
implements JaResultParseHandler<T> {
    public static final int OK = 200;
    private Integer status;
    private String statusDescription;
    private String code;
    private String errorCode;
    private Object errorMessage;
    private String errorType;
    private T response;
    private Long serverTime;
    private String path;
    @Deprecated
    private String traceId = JaCoreAdapter.getTraceId();
    private Object debugInfo;
    private String description;
    private String bizErrorCode;
    private String bizErrorMsg;
    private Map<String, Object> espError;

    @JsonIgnore
    public boolean isOK() {
        if (JaMetaUtil.isNotEmpty((String)this.errorCode)) {
            return false;
        }
        return null != this.status && 200 == this.status;
    }

    @JsonIgnore
    public T getResponseWithException(String errorMessagePrefix) {
        if (this.isOK()) {
            return this.response;
        }
        String message = errorMessagePrefix + this.getErrorMessage();
        throw BusinessException.create(599, this.getErrorCode(), message, message, "\u8bbf\u95ee\u5916\u90e8api\u9519\u8bef", this.getErrorType(), null);
    }

    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public T getResponse() {
        return this.response;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public Long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(Long serverTime) {
        this.serverTime = serverTime;
    }

    public Object getDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(Object debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBizErrorCode() {
        return this.bizErrorCode;
    }

    public void setBizErrorCode(String bizErrorCode) {
        this.bizErrorCode = bizErrorCode;
    }

    public String getBizErrorMsg() {
        return this.bizErrorMsg;
    }

    public void setBizErrorMsg(String bizErrorMsg) {
        this.bizErrorMsg = bizErrorMsg;
    }

    public Map<String, Object> getEspError() {
        return this.espError;
    }

    public void setEspError(Map<String, Object> espError) {
        this.espError = espError;
    }

    public Boolean success() {
        return this.isOK();
    }

    public String code() {
        return this.code;
    }

    public String message() {
        return null == this.errorMessage ? null : this.errorMessage.toString();
    }

    public T data() {
        return this.response;
    }
}

