package com.digiwin.athena.appcore.domain;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jugg.agile.framework.meta.JaMetaUtil;
import com.jugg.agile.framework.meta.adapter.JaCoreAdapter;
import com.jugg.agile.framework.meta.handler.JaResultParseHandler;

import java.util.Map;

/**
 * 基础结果类
 */
public class BaseResultDTO<T> implements JaResultParseHandler<T> {

    public static final int OK = 200;

    public BaseResultDTO() {
        this.traceId = JaCoreAdapter.getTraceId();
    }

    /**
     * 状态码，如：200
     */
    private Integer status;

    /**
     * 状态码描述，如：OK
     */
    private String statusDescription;

    /**
     * 错误码
     */
    private String code;
    /**
     * 错误码，业务正常时为null
     */
    private String errorCode;

    /**
     * 错误码描述，业务正常时为null
     */
    private Object errorMessage;

    /**
     * 错误类型，不一定有值，如：System/Business/Unexpected，
     */
    private String errorType;

    private T response;

    private Long serverTime;

    private String path;

    @Deprecated
    private String traceId;

    private Object debugInfo;

    private String description;
    /**
     * 针对iam校验token是否失效错误码，业务正常时为null
     */
    private String bizErrorCode;

    /**
     * 针对iam校验token是否失效错误码描述，业务正常时为null
     */
    private String bizErrorMsg;

    /**
     * esp 业务异常
     */
    private Map<String, Object> espError;

    /**
     * 请求是否OK，errorCode不为0 且 status==200，则认为请求OK
     */
    @JsonIgnore
    public boolean isOK() {
        if (JaMetaUtil.isNotEmpty(errorCode)) {
            return false;
        }

        return null != status && OK == status;
    }

    @JsonIgnore
    public T getResponseWithException(String errorMessagePrefix) {
        if (isOK()) {
            return response;
        }
        String message = errorMessagePrefix + this.getErrorMessage();
        throw BusinessException.create(599, this.getErrorCode(), message, message, "访问外部api错误", this.getErrorType(), null);
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getStatusDescription() {
        return statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(Object errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorType() {
        return errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public T getResponse() {
        return response;
    }

    public void setResponse(T response) {
        this.response = response;
    }

    public Long getServerTime() {
        return serverTime;
    }

    public void setServerTime(Long serverTime) {
        this.serverTime = serverTime;
    }

    public Object getDebugInfo() {
        return debugInfo;
    }

    public void setDebugInfo(Object debugInfo) {
        this.debugInfo = debugInfo;
    }

    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBizErrorCode() {
        return bizErrorCode;
    }

    public void setBizErrorCode(String bizErrorCode) {
        this.bizErrorCode = bizErrorCode;
    }

    public String getBizErrorMsg() {
        return bizErrorMsg;
    }

    public void setBizErrorMsg(String bizErrorMsg) {
        this.bizErrorMsg = bizErrorMsg;
    }

    public Map<String, Object> getEspError() {
        return espError;
    }

    public void setEspError(Map<String, Object> espError) {
        this.espError = espError;
    }

    @Override
    public Boolean success() {
        return isOK();
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String message() {
        return null == errorMessage ? null : errorMessage.toString();
    }

    @Override
    public T data() {
        return response;
    }
}
