package com.digiwin.athena.appcore.auth;

import com.digiwin.athena.appcore.auth.domain.AuthoredSys;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;

import java.io.Serializable;
import java.util.Map;

/**
 * 存储应用授权相关的数据
 */
public class AppAuthContext implements Serializable {
    /**
     * 登录成功用户
     */
    private AuthoredUser authoredUser;

    /**
     * 代理token的用户
     */
    private AuthoredUser proxyAuthoredUser;

    /**
     * 代理的token
     */
    private String proxyToken;

    /**
     * 登录的sys
     */
    private AuthoredSys authoredSys;

    /**
     * 信任链用的key，减少多次调用iam的api
     */
    private String securityToken;

    /**
     * 集成账号的用户信息
     */
    private AuthoredUser integrationAuthoredUser;
    /**
     * 请求头信息
     */
    private Map<String, Object> requestHeader;

    public AppAuthContext(){

    }
    /**
     * 构造函数
     * @param authoredUser
     * @param authoredSys
     */
    public AppAuthContext( AuthoredUser authoredUser, AuthoredSys authoredSys){
        this.authoredUser=authoredUser;
        this.authoredSys=authoredSys;
    }

    public AuthoredUser getAuthoredUser() {
        return authoredUser;
    }

    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public AuthoredUser getProxyAuthoredUser() {
        return proxyAuthoredUser;
    }

    public void setProxyAuthoredUser(AuthoredUser proxyAuthoredUser) {
        this.proxyAuthoredUser = proxyAuthoredUser;
    }

    public AuthoredSys getAuthoredSys() {
        return authoredSys;
    }

    public void setAuthoredSys(AuthoredSys authoredSys) {
        this.authoredSys = authoredSys;
    }

    public String getProxyToken() {
        return proxyToken;
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    public String getSecurityToken() {
        return securityToken;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public AuthoredUser getIntegrationAuthoredUser() {
        return integrationAuthoredUser;
    }

    public void setIntegrationAuthoredUser(AuthoredUser integrationAuthoredUser) {
        this.integrationAuthoredUser = integrationAuthoredUser;
    }

    public Map<String, Object> getRequestHeader() {
        return requestHeader;
    }

    public void setRequestHeader(Map<String, Object> requestHeader) {
        this.requestHeader = requestHeader;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof AppAuthContext) {
            AppAuthContext test = (AppAuthContext)obj;
            if (this.getAuthoredUser() == null && test.getAuthoredUser() == null &&
                    this.getAuthoredSys() == null && test.getAuthoredSys() == null
            ) {
                return true;
            }


            if (this.getAuthoredUser() != null && test.getAuthoredUser() != null && this.getAuthoredUser().equals(test.getAuthoredUser())
                    && this.getAuthoredSys() != null && test.getAuthoredSys() != null && this.getAuthoredSys().equals(test.getAuthoredSys())
            ) {
                return true;
            }
        }

        return false;
    }

    @Override
    public int hashCode() {
        int hash= this.authoredUser == null ? -1 : this.authoredUser.hashCode();
        int hash2= this.authoredSys == null ? -1 : this.authoredSys.hashCode();
        return hash ^ hash2;
    }

}
