package com.digiwin.athena.appcore.auth.domain;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 服务授权代理人
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IdentityUser {

    /**
     * 租户id
     */
    private String tenantId;

    /**
     * 被代理的用户id，即当前登录的用户id
     */
    private String id;

    /**
     * 代理的用户id，即实际操作的用户id
     */
    private String agentUserId;

    /**
     * 代理的用户名称，即实际操作的用户名称
     */
    private String agentUserName;

}
